<?php
class Auth {
    public function verifyToken() {
        // Only allow OPTIONS and HEAD without auth for video probing
        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            return true;
        }

        $headers = getallheaders();
        error_log("Headers: " . print_r($headers, true));
        error_log("GET params: " . print_r($_GET, true));
        error_log("Request Method: " . $_SERVER['REQUEST_METHOD']);
        
        // Try to get token from various sources
        $token = null;

        // Check Authorization header (case-insensitive)
        foreach ($headers as $name => $value) {
            if (strtolower($name) === 'authorization') {
                $token = str_replace('Bearer ', '', $value);
                break;
            }
        }
        
        // If no token in header, check query parameter
        if (!$token && isset($_GET['auth_token'])) {
            $token = $_GET['auth_token'];
        }

        // Allow HEAD requests without token for video probing
        if ($_SERVER['REQUEST_METHOD'] === 'HEAD') {
            return true;
        }

        error_log("Found token: " . ($token ?? 'none'));
        $isValid = $this->validateToken($token);

        // If this is a video request, ensure we have a valid token
        if (strpos($_SERVER['REQUEST_URI'], '.mp4') !== false && !$isValid) {
            error_log("Video request denied - invalid token");
            return false;
        }

        return $isValid;
    }
    
    public function validateToken($token) {
        try {
            if (empty($token)) {
                error_log("Token is empty");
                return false;
            }
            // Add more robust token validation here
            if (strlen($token) < 32) {
                error_log("Token too short");
                return false;
            }
            error_log("Token validation successful");
            return true;
        } catch (Exception $e) {
            error_log("Token validation error: " . $e->getMessage());
            return false;
        }
    }
}
?> 