<?php
$logFile = '/home/natasun/helgehaukeland.com/secure_storage/logs/backup.log';
$backupUrl = 'https://helgehaukeland-test.vercel.app/api/backup/auto';  // Update with your actual domain
$apiKey = 'your-secret-key'; // Use the actual key here

error_log("Starting backup process at " . date('Y-m-d H:i:s') . "\n", 3, $logFile);

try {
    error_log("Attempting to connect to: $backupUrl\n", 3, $logFile);
    
    $ch = curl_init($backupUrl . '?key=' . urlencode($apiKey));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 3600); // 1 hour timeout
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // For testing only
    
    // Add detailed error reporting
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    $verbose = fopen('php://temp', 'w+');
    curl_setopt($ch, CURLOPT_STDERR, $verbose);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    // Log curl verbose output
    rewind($verbose);
    $verboseLog = stream_get_contents($verbose);
    error_log("Curl verbose output:\n" . $verboseLog . "\n", 3, $logFile);
    
    if ($httpCode !== 200) {
        throw new Exception("Backup failed with status code: " . $httpCode . ", Response: " . $response);
    }
    
    error_log("[AUTO_BACKUP] Backup completed successfully at " . date('Y-m-d H:i:s') . "\n", 3, $logFile);
} catch (Exception $e) {
    error_log("[AUTO_BACKUP_ERROR] " . $e->getMessage() . "\n", 3, $logFile);
} finally {
    if (isset($ch)) {
        curl_close($ch);
    }
}
?> 