<?php
// Backup handling functions
function handleBackupUpload() {
    header('Content-Type: application/json');
    
    if (!isset($_FILES['backup'])) {
        http_response_code(400);
        echo json_encode(['error' => 'No backup file uploaded']);
        return;
    }

    $file = $_FILES['backup'];
    $uploadDir = '/home/natasun/helgehaukeland.com/secure_storage/backups/';
    
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }
    
    $newFileName = 'backup-' . date('Y-m-d-H-i-s') . '-' . basename($file['name']);
    $targetPath = $uploadDir . $newFileName;
    
    if (move_uploaded_file($file['tmp_name'], $targetPath)) {
        echo json_encode(['success' => true, 'fileName' => $newFileName]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to upload backup']);
    }
}

function handleListBackups() {
    $dir = '/home/natasun/helgehaukeland.com/secure_storage/backups';
    $files = [];
    
    if (is_dir($dir)) {
        foreach (scandir($dir) as $file) {
            if ($file !== '.' && $file !== '..') {
                $path = $dir . '/' . $file;
                $files[] = [
                    'name' => $file,
                    'size' => filesize($path),
                    'created' => date('Y-m-d H:i:s', filemtime($path)),
                    'format' => pathinfo($file, PATHINFO_EXTENSION)
                ];
            }
        }
    }
    
    header('Content-Type: application/json');
    echo json_encode(['backups' => $files]);
}

function handleGetBackup() {
    $file = $_GET['file'] ?? '';
    if (empty($file)) {
        header('Content-Type: application/json');
        http_response_code(400);
        echo json_encode(['error' => 'Missing file parameter']);
        return;
    }

    $filePath = '/home/natasun/helgehaukeland.com/secure_storage/backups/' . basename($file);
    
    if (!file_exists($filePath)) {
        header('Content-Type: application/json');
        http_response_code(404);
        echo json_encode(['error' => 'Backup not found']);
        return;
    }

    $ext = pathinfo($filePath, PATHINFO_EXTENSION);
    $mimeTypes = [
        'zip' => 'application/zip',
        'sql' => 'application/sql',
        'json' => 'application/json',
        'csv' => 'text/csv'
    ];

    header('Content-Type: ' . ($mimeTypes[$ext] ?? 'application/octet-stream'));
    header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
    header('Content-Length: ' . filesize($filePath));
    readfile($filePath);
}
?> 